import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*
import java.io.FileInputStream
import java.util.zip.GZIPInputStream
import java.lang.Thread.*

/*
 * WebResource extractor plugin for hahasport.com.
 *
 * see full schedule at www.hahasport.com
 * 
 * @author jhb50
 * Version 3 - Apr 30, 2012
 * Version 4 - May 12, 2012  Disable Castamp Decode
 * Version 5 - May 23, 2012  Extend No Source link detection
 * Version 6 - Aug 13, 2012  Reenable Castamp Decode & add version log
 * Version 7 - Aug 23, 2012  Update Castalba Extraction Code & remove 404 test for Serviio 1.0
 * Version 8 - Aug 31, 2012  Update Castamp Extraction Code
 * Version 9 - Oct 29, 2012  New Ilive IP.
 * Version 10 - Nov 10,2012  Read with GZIP
 * Version 11 - Nov 17,2012  New Leton IP 
 * Version 12 - Dec 12,2012  New Leton IP
 * Version 13 - Dec 13,2012  New Leton IP
 * Version 14 - Dec 20,2012  Limit parsing to 50 feed items to prevent timeout
 * Version 15 - Dec 30,2012  Correct next item refresh time.
 * Version 16 - Dec 31,2012  verify network active before parsing
 * Version 17 - Jan  6,2013  Support New Web format and Leton & IliveIP's, Add hqfooty, frame2, nutjob, castasap and coolsport sources & add ETimers
 * Version 18 - Jan 11,2013  Support New Web format
 * Version 19 - Jan 11,2013  Correct refresh time error
 * Version 20 - Jan 12,2013  Tuned, Coolsport source change
 * Version 21 - Jan 13,2013  Liveall source change
 * Version 22 - Feb  3,2013  Many source changes, Genurls added by default to minimize extracts
 * Version 23 - Feb  4,2013  Skipped to match Stopstream
 * Version 24 - Feb  4,2013  Improved Expiry time logic
 * Version 25 - Feb  5,2013  Support Quick Refresh for subsets.
 * Version 26 - Feb 10,2013  Skip bad source Urls
 * Version 27 - Feb 18,2013  Support GZIP source format
 * Version 28 - Feb 19,2013  Add Livego source support 
 * Version 29 - Mar  8,2013  Increase Extract Timeout to 60 seconds 
 * Version 30 - Apr 15,2013  update hdcast, ilive & leton uri
 * Version 31 - May 23,2013  add sawlive sources, adjust event end refreshes, new web page, update ips, add featve redirect & token. 
 *
 *
 */
class HaHaSport extends WebResourceUrlExtractor {
	String Token = "#fe%#w@3fe%#w@3s#Ch%3al#w#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2#fe%#w@3fe%#w@3s#Ch%3al#w@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2sad3@2s#Ch%3alfe%#w@3s#Ch%3al#w@2#w@2"

	long StartETime = 0
	long LastETime2 = 0
	long LastETime3 = 0

	String ucasterUri
	String mipsUri
	String liveflashUri
	
	long lowestRefresha = 99999999
	
	List<WebResourceItem> newitems = []
	List<WebResourceItem> olditems = []

	final VALID_FEED_URL = '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?'
	
	String getExtractorName() {
		return 'HaHaSport'
	}
	
	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL
	}
	
	int getVersion() {
		return 31
	}

	int getExtractItemsTimeout() {
		return 90
	}	

	Long ETimer(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - StartETime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}

	Long ETimer2(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - LastETime2
		LastETime2 = CurrentTime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}
	
	Long ETimer3(String msg){
		long CurrentTime = System.currentTimeMillis()
		long Elapsed = CurrentTime - LastETime3
		LastETime3 = CurrentTime
		if (msg != null){
			log("$msg = $Elapsed msec")
		}
		return Elapsed
	}

	Boolean URLExists(String srcURL){
		URL fileURL = new URL(srcURL);
		if(((HttpURLConnection) fileURL.openConnection()).getResponseCode() == 404){
			return false
		}
		return true
	}

	String OpenProtURL(	String srcURL,	String Referrer	) {        

		def rv = ""
		URL url = new URL(srcURL);
		URLConnection conn = url.openConnection();
		conn.setRequestProperty("Referer", Referrer);
		conn.setRequestProperty("User-Agent","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1");
		conn.setRequestProperty("Accept-Language","en-US");
		conn.setDoOutput(true);

		BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
		String line;
		while ((line = rd.readLine()) != null) {
			rv += line
		}
		rd.close();        
        return rv
    }

	WebResourceContainer extractItems(URL resourceUrl, int maxItems) {

		log("Parsing with HaHaSport V${getVersion()}")
		StartETime = System.currentTimeMillis()
		ETimer2()

		ucasterUri = ""
		mipsUri = ""
		liveflashUri = ""

		def genurls = 1
		def curDate = new Date(System.currentTimeMillis()+300000)
		olditems = []
		if (newitems){
			def newitemssize = newitems.size()
			def nli = newitems.iterator()
			while (nli.hasNext()){
				def newEntry = nli.next()
				if(newEntry.getAdditionalInfo()['XexpiresImmediately']!= true) continue
				def SavedExpiryDate = newEntry.getAdditionalInfo()['XexpiresOn']
				if(SavedExpiryDate > new Date(0) && curDate >= SavedExpiryDate) continue
				olditems << newEntry
			}
			def olditemssize = olditems.size()
			log ( olditemssize + " items saved, " + (newitemssize - olditemssize) +  " expired" )
			olditems = olditems.drop(olditemssize-300)
			newitems = olditems
		}
		
		
		while(1) {
			def test_text = openURL(new URL("http://www.dogpile.com"),
				"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
			def testMatch = test_text ==~ '(?s).*?Dogpile Web Search.*?'
			if (testMatch) break
		}
		
			
		List<WebResourceItem> items = []
		def itemsAdded = 0
		String videoTitle = ""
		String rtmpUrl = ""
		String secCode = ""
		String thumbnailUrl = ""
		String pageThumb = ""
		String nextTitle = ""
		String itemFlag = "None"
		String linkTitle = ""
		String feed = ""
		String srcUrl = ""
		String videoUrl = ""
		String refreshtxt = ""
		def onDemand = false
		def repId = ""
		def icon = false
		String lastTitle = ""
		String videoTitle1 = ""
		String videoTitle2 = ""
		long time = 0
		
		long defRefreshi = 0
		
		def  lowestRefreshat = ""
		long itemRefresha = 0
		def  itemRefreshat = ""


		def parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?genurls=([0-1])'
		def parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?genurls=[0-1].*?'
		if (parmMatch){
		    genurls = parmMatcher[0][1].trim()  
		}

		parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?refresh=(.[0-9]+).*?'
		parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?refresh=.[0-9]+.*?'
		if (parmMatch){
			defRefreshi = parmMatcher[0][1].trim().toLong()
			long curTime=System.currentTimeMillis()/60000
			lowestRefresha = (System.currentTimeMillis()/60000) + defRefreshi + 5
		}

		parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?time=([0-9]+)'
		parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?time=[0-9]+.*?'
		if (parmMatch){
			time = parmMatcher[0][1].trim().toShort()
			if (time < -24 || time > 24) time = 0
			time = time * 60
		}
		
		parmMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?repid=(.[0-9]+).*?'
		parmMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?repid=[0-9]+.*?'
		if (parmMatch){
			repId = parmMatcher[0][1].trim()  
			icon = true
			onDemand = true
		}
		
		long curTimea = System.currentTimeMillis()/60000

		if (lowestRefresha == 99999999) lowestRefreshat = "Console Default"
		else
		lowestRefreshat = new Date((lowestRefresha-5)*60000).format("H:mm 'on' E M/dd/yyyy").trim()	 

		int estreams = 1
		int estreamsCount = 0
		def estreamsMatcher = resourceUrl =~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?streams=([0-9]+)'
		def estreamsMatch = resourceUrl ==~ '^(?:https?://)?(?:www\\.)?hahasport\\.com.*?streams=[0-9]+.*?'
		if (estreamsMatch){
			estreams = estreamsMatcher[0][1].trim().toInteger()  
		}

		if (resourceUrl.toString().contains("?")){
			def maskMatcher = resourceUrl =~ '^(.*?)\\?.*?'
			resourceUrl = new URL(maskMatcher[0][1].trim())
		}
		
		String html = new GZIPInputStream (resourceUrl.newInputStream(requestProperties:['Accept-Encoding': 'gzip,deflate'])).text			

		String pageTitle = "HaHaSports"

		if (icon){
			linkTitle = "http://refreshitem"
			srcUrl = "http://refreshitem"
			videoUrl = "http://refreshitem"
			
			thumbnailUrl = "https://sites.google.com/site/serviiorss/refresh.jpg"
			videoTitle = "Click to Refresh "
			log ("ADDED 'REFRESH ON DEMAND' ")

			WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'repId':repId,'onDemand':onDemand,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbnailUrl':thumbnailUrl,'curTimea':curTimea,'itemRefresha':lowestRefresha])

			items << item
		}

	   	if (html.count('<table class') > 0 ){

			def blockMatcher = html =~ '(?s)<tr.*?<td>(.*?)</tr>'

			for( int i = 0; i < blockMatcher.size() && (maxItems == -1 || itemsAdded < maxItems) ; i++ ) {
								
				if (ETimer() > 86000){
					log ("Time Limit of 90 Seconds Reached") 
					println "\r\nTime Limit of 90 Seconds Reached\r\n"
					break
				}
				
				
				

				def videoMatch = blockMatcher[i][1] ==~ '(?s).*?title=".*?<script>.*?'
				def title = 1 
				def videoMatcher
				if (videoMatch){
					title = 0
					videoMatcher = blockMatcher[i][1] =~ '(?s)<a href.*?time">(.*?)<.*?time">(.*?)<.*?flag.flag-(.*?)".*?class=".*?">(.*?)<.*?href="(.*?)".*?</script>(.*?)</a>'
				}
				else
					videoMatcher = blockMatcher[i][1] =~ '(?s)<a href.*?time">(.*?)<.*?time">(.*?)<.*?flag.flag-(.*?)".*?class=".*?">(.*?)<.*?href="(.*?)".*?title=".*?">(.*?)</a>'

				long sTimea = (videoMatcher[0][1].trim().toLong()/60)+time 
				long eTimea = (videoMatcher[0][2].trim().toLong()/60)+time 

				if (sTimea < (curTimea - 1440) || eTimea < (curTimea - 60)) {
					continue
				}
				
				videoTitle2 = videoMatcher[0][6].trim()
				if (videoTitle2.contains("Unibet") || videoTitle2.contains("Bet365") || videoTitle2.contains("BWIN") || videoTitle2.contains("Sopcast") || videoTitle2.contains("SopCast") || videoTitle2.contains("Veetle") || videoTitle2.contains("Cast3d")){
					continue
				}

				videoUrl = videoMatcher[0][5].trim()

				String videohtml
				try {
					videohtml = new GZIPInputStream ((new URL(videoUrl).newInputStream(requestProperties:['Accept-Encoding': 'gzip,deflate']))).text
				 } catch (IOException e) {
					 println("e = " + e + "-" + videoTitle1 + "-" + videoUrl);
					 log("e = " + e + "-" + videoTitle1 + "-" + videoUrl);
					 continue
				 }
				 
				 if(videohtml == "") continue
				
				def javaMatch = videohtml ==~ '(?s).*?\'Javascript\'>document.write.*?'
				if (!javaMatch){
					log("NO DETAIL ENTRIES FOR THIS ITEM - \'$videoUrl\'") 
					continue
				}
				
				def dlinkMatcher = videohtml =~ '(?s)<title>Watch Live (.*?)Online.*?\'Javascript\'>document.write\\(unescape\\(\'(.*?)\'\\)'

				videoTitle1 = videoMatcher[0][4].trim()
				videoTitle1 = videoTitle1.replaceAll("\\s+"," ")
				videoTitle1 = videoTitle1.replaceAll(" -","-")
				videoTitle1 = videoTitle1.replaceAll("- ","-")
				if (videoTitle2 == "") videoTitle2 = dlinkMatcher[0][1].trim()
				else if (title == 0) videoTitle2 = dlinkMatcher[0][1].trim() + " " + videoTitle2
				videoTitle2 = videoTitle2.expand(1)
				videoTitle2 = videoTitle2.replaceAll("\\s+"," ")
				videoTitle2 = videoTitle2.replaceAll("\\( ","\\(")
				videoTitle2 = videoTitle2.replaceAll(" \\)","\\)")
				videoTitle2 = videoTitle2.replaceAll(" -","-")
				videoTitle2 = videoTitle2.replaceAll("- ","-")

				videoTitle = videoTitle2 + "|" + videoTitle1

				if (videoTitle != lastTitle){ 
					estreamsCount = 0
				}
				else if (estreams == estreamsCount && estreams != 9){
					log ("DUPLICATE ITEM - $videoTitle")
					continue
				}
				linkTitle = dlinkMatcher[0][2].trim()
				linkTitle = URLDecoder.decode(linkTitle)
				if (!(linkTitle.contains('src="') || linkTitle.contains('SRC="') || linkTitle.contains("src='") || linkTitle.contains("SRC='"))){
					log("NO SRC ITEM - \'$videoTitle\'") 
					continue
				}
				def srcMatcher = linkTitle =~ '(?s)[sS][rR][cC]=[\'"](.*?)[\'"&]'
				srcUrl = srcMatcher[0][1].trim()
				
				String sTimeat = new Date(sTimea*60000).format('E H:mm').trim()
				String eTimeat = new Date(eTimea*60000).format('H:mm').trim()
				String pTimesat = sTimeat + "-" + eTimeat
				videoTitle = pTimesat + " " + videoTitle	
				
				if (srcUrl.contains("http://www.ilive.to")) 			feed = "ilivet"
				else if (srcUrl.contains("http://coolsport.tv"))		feed = "coolsp"
				else if (srcUrl.contains("http://nutjob.eu"))			feed = "nutjob"
				else if (srcUrl.contains("http://hqfooty.tv"))			feed = "hqfoot"
				else if (srcUrl.contains("http://frametv2.blogspot.co.uk"))	feed = "frame2"
				else if (srcUrl.contains("http://frametv3.blogspot.co.uk"))	feed = "frame3"
				else if (srcUrl.contains("http://liveall.tv"))			feed = "livall"
				else if (srcUrl.contains("http://www.hdcast.tv")) 		feed = "hdcast"  
				else if (srcUrl.contains("http://www.yycast.com"))		feed = "yycast"
				else if (srcUrl.contains("http://mypremium.tv"))		feed = "myprem"		
				else if (srcUrl.contains("http://www.mips.tv"))			feed = "mipstv"	
				else if (srcUrl.contains("http://cricfree.tv"))			feed = "cricfr"
				else if (srcUrl.contains("http://distro.megom.tv"))		feed = "megomt"
				else if (srcUrl.contains("http://leton.tv"))		feed = "letont"	
				else if (srcUrl.contains("http://surk.tv"))			feed = "surktv"
				else if (srcUrl.contains("http://www.007stream.com"))		feed = "007str"
				else if (srcUrl.contains("http://www.ustream.tv"))		feed = "ustrea"
				else if (srcUrl.contains("http://www.castalba.tv"))		feed = "castal"
				else if (srcUrl.contains("http://liveview365.tv"))		feed = "liv365"
				else if (srcUrl.contains("http://www.wii-stream.com"))		feed = "wiistr"
				else if (srcUrl.contains("http://www.castup.tv/"))		feed = "castup"
				else if (srcUrl.contains("http://www.castamp.com/"))		feed = "castam"

				else{
					if (srcUrl.contains("sportlemon.tv/images/video.png")) 	feed="offair"
					else feed = srcUrl
					
					long spread = 3
					long adjsTimea = sTimea + 5 + spread

					if (sTimea > (curTimea + 2400 )) {
						continue
					}

					if (sTimea < curTimea){
						log ("NULL ITEM - $feed - $videoTitle")
						continue
					}
					else if (sTimea > (curTimea + spread)){
						if ((sTimea + 5 - spread) < lowestRefresha) lowestRefresha = sTimea + 5 - spread 

						itemRefresha = sTimea - spread
						 itemRefreshat = new Date(itemRefresha*60000).format("H:mm 'on' E").trim()
						if (onDemand) refreshtxt = "Refresh On Demand or at $itemRefreshat"
						else refreshtxt = "Refresh at $itemRefreshat"
												
						nextTitle = videoTitle
						itemFlag = "Next"
						log ("NEXT ITEM - $feed - $videoTitle - $refreshtxt")
						break;
					}
	
					else if(curTimea < sTimea) {
						if ((sTimea + 5 ) < lowestRefresha && feed =="offair" ) lowestRefresha = sTimea + 5  
					}
					else{
						if ((sTimea + 5 + spread) < lowestRefresha ) lowestRefresha = sTimea + 5 + spread    
					}							
					itemFlag = itemFlag
					log ("NULL ITEM - $feed - $videoTitle")
					continue					
				}	

				if ((eTimea +10) > curTimea) itemRefresha = eTimea + 15
				else itemRefresha = eTimea + 75
				itemRefreshat = new Date((itemRefresha-5)*60000).format(" H:mm 'on' E ").trim()		

				if ((itemRefresha < lowestRefresha)) lowestRefresha = itemRefresha
				
				String flag = videoMatcher[0][3].trim()
				String myflags = "ae ar at au ba be bg br bw ca ch cl cn co cz de en es eu fr gb gh gr hr hu ie it ix kp kw lt ma mx nl no pl pt py qa ro rs ru s1 sa se si sk sz tr ua uk us uy wa za "
				if (myflags.contains(flag)) thumbnailUrl = "https://sites.google.com/site/hahaflags/" + flag + ".gif"
				else 
				thumbnailUrl = "http://www.worldatlas.com/webimage/flags/countrys/zzzflags/" + flag + "small.gif"
	
				if (onDemand) refreshtxt = "Refresh On Demand or at $itemRefreshat"
				else refreshtxt = "Refresh at $itemRefreshat"
	
				log ("LIVE ITEM - $feed - $videoTitle - $refreshtxt " )
				
				itemFlag = "Live"
				
				lastTitle = videoTitle
				estreamsCount = estreamsCount + 1
				
				def itemkey = videoUrl + "_" + videoTitle

				WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['itemkey':itemkey,'resourceUrl':resourceUrl,'repId':repId,'onDemand':onDemand,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbnailUrl':thumbnailUrl,'itemRefresha':itemRefresha])

				item.additionalInfo.put('gen',"false")
				if(olditems && itemkey){
					for (int oij=olditems.size(); oij > 0; oij--){
						String olditem = olditems.getAt(oij-1).toString()
						if(olditem.contains(itemkey)){
							item.additionalInfo.put('oindx',oij-1)
							if (genurls) item.additionalInfo.put('gen',"true")
							break
						}
					}
				}
				
				items << item
				itemsAdded++
			}
		}
	
		
		if (onDemand) lowestRefreshat = "On Demand or at $lowestRefreshat"
		else{
			if (lowestRefresha == 99999999) lowestRefreshat = "Console Default"
			else
			lowestRefreshat = "at " + new Date((lowestRefresha-5)*60000).format("H:mm 'on' E ").trim()
		}
	
		linkTitle = "http://lastitem"
		srcUrl = "http://lastitem"
		videoUrl = "http://lastitem"
			
		if (itemFlag == 'Live'){
			thumbnailUrl = "https://sites.google.com/site/serviiorss/nomoreevents.jpg"
			videoTitle = "Next Refresh $lowestRefreshat"
			log ("ADDED 'NO MORE EVENTS' - $videoTitle")
		}
		else 
		if (itemFlag == 'Next') {
			thumbnailUrl = "https://sites.google.com/site/serviiorss/nextevent.jpg"
			videoTitle = "$nextTitle - Next Refresh $lowestRefreshat "
			log ("ADDED 'NEXT EVENT' - $videoTitle")
		}
		else
		if (itemFlag == 'None') {
			thumbnailUrl = "https://sites.google.com/site/serviiorss/noevents.jpg"
			videoTitle = "Next Refresh $lowestRefreshat"
			log ("ADDED 'NO EVENTS' - $videoTitle")
		}

		WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'repId':repId,'onDemand':onDemand,'linkTitle':linkTitle,'srcUrl':srcUrl,'videoUrl':videoUrl,'thumbnailUrl':thumbnailUrl,'itemRefresha':itemRefresha])

		item.additionalInfo.put('gen',"false")

		items << item
		
		ETimer("Total $itemsAdded Items Found")
		
		return new WebResourceContainer(title: pageTitle, thumbnailUrl: pageThumb, items: items)
	}
	
	
	ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality) {		
		
		String videoTitle = item.title
		String resourceUrl = item.getAdditionalInfo()['resourceUrl']

		String linkTitle = item.getAdditionalInfo()['linkTitle']
		String srcUrl = item.getAdditionalInfo()['srcUrl']
		String videoUrl = item.getAdditionalInfo()['videoUrl']
		String thumbnailUrl = item.getAdditionalInfo()['thumbnailUrl']
		
		def onDemand = item.getAdditionalInfo()['onDemand']
		long itemRefresha = item.getAdditionalInfo()['itemRefresha'].toLong() 

		String feed = ""
		String secCode = ""
		String rtmpUrl = ""
		def expiryDate 
		String cacheKey = ""
		def expiresImmediately
		def itemExpires 
	
		String gen = item.getAdditionalInfo()['gen']

		if(gen == "false"){
			println "\r\nExtracting Url for $videoTitle"
			
			if (srcUrl.contains("http://refreshitem") || srcUrl.contains("http://lastitem")){

				if (srcUrl.contains("http://refreshitem")){
					log("Source Link: $srcUrl")
					println "Source Link: $srcUrl"
					String repId = item.getAdditionalInfo()['repId']
					rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v" + repId + "/reflector:53708"
				}

				else if (srcUrl.contains("http://lastitem")){
					log("Source Link: $srcUrl")
					println "Source Link: $srcUrl"
					rtmpUrl = "rtsp://a1709.l1856953708.c18569.g.lm.akamaistream.net:554/D/1709/18569/v00/reflector:53708"
				}
				
				secCode = "abcdefghi"
				cacheKey = "http://lastitem_" + secCode
				expiresImmediately = false
				
				if (itemRefresha < 99999999) expiryDate = new Date(lowestRefresha * 60000)
			}
				
			else{	

				if (srcUrl.contains("http://www.ilive.to")){

					srcUrl = srcUrl.replaceAll("embed","view")
					log("Source Link: $srcUrl")

				
					def linkHtml = openURL( new URL(srcUrl),
						"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 

					def secMatch = linkHtml ==~ '(?s).*?flashplayer: ".*?streamer: ".*?file: ".*?'
					def secMatcher = linkHtml =~ '(?s)flashplayer: "(.*?)".*?streamer: "(.*?)".*?file: "(.*?).flv.*?'
					if (secMatch){
						secCode = secMatcher[0][3].trim()
					}
					else{
						log ("No playpath found for $srcUrl")
						println "No playpath found for $srcUrl"
						return
					}
					
					rtmpUrl = secMatcher[0][2].trim() + " playpath=" + secCode + " swfurl=" + secMatcher[0][1].trim() + " pageurl=http://www.ilive.to live=1" 

				}	

				else if (srcUrl.contains("http://distro.megom.tv")){

					log("Source Link: $srcUrl")

					String linkHtml = new URL(srcUrl).getText()

					def errorMatch = linkHtml ==~ '(?s).*?ban.png.*?'
					if (errorMatch){
						log ("MEGOM - Video Banned - $videoTitle")
						return null
					}
					def rtmpMatcher = linkHtml =~ /(?s)testkey=(.*?)['<].*?/
					if(!rtmpMatcher){
						log ("MEGOM - No testkey - $videoTitle")
						return null
					}

					String rtmpKey = rtmpMatcher[0][1].trim()
					
					def secMatcher = linkHtml =~ /(?s)'file'.*?'(.*?)'.*?/
					if (!secMatcher){
						log("No file playpath in " + srcUrl)
						println "No file playpath in " + srcUrl
						return
					}

					secCode = secMatcher[0][1].trim()

					rtmpUrl = "rtmp://213.163.71.196:1935/streams?testkey=" + rtmpKey + " swfUrl=http://lds.megom.tv/player.swf pageURL=http://distro.megom.tv/player-inside.php?id=" + secCode + " playpath=" + secCode 
				}
				
				else if (srcUrl.contains("http://leton.tv")){

					log("Source Link: $srcUrl")
					
					String linkHtml = new URL(srcUrl).getText()
					def errorMatch = linkHtml ==~ '(?s).*?letonban.png.*?'
					if (errorMatch){
						log ("LETON - Video Banned - $videoTitle")	
						return null
					}
					def rtmpMatcher = linkHtml =~ /(?s)testkey=(.*?)'.*?/
					if(!rtmpMatcher){
						log("No testkey in " + srcUrl)
						println "No testkey in " + srcUrl
						return
					}
					String rtmpKey = rtmpMatcher[0][1].trim()

					def secMatcher = linkHtml =~ /(?s)'file','(.*?)'.*?/
					if (!secMatcher){
						log("No file playpath in " + srcUrl)
						println "No file playpath in " + srcUrl
						return
					}
					secCode = secMatcher[0][1].trim()


					rtmpUrl = "rtmp://174.36.55.73/pull?testkey=" + rtmpKey + " playpath=" + secCode +" swfUrl=http://files.leton.tv/player.swf" +" pageUrl=http://leton.tv/player_pop.php live=1" 
				}
				
				else if (srcUrl.contains("http://surk.tv")){

					def secMatcher = linkTitle =~ '(?s)id=(.*?)&.*?'
					if (!secMatcher) secMatcher = linkTitle =~ /(?s)id=['"](.*?)['"].*?/
					if (!secMatcher){
						log("No id= playpath in " + srcUrl)
						println "No id= playpath in " + srcUrl
						return
					}
					secCode = secMatcher[0][1].trim()
					secCode = secCode.replaceAll('"','')
					srcUrl = "http://surk.tv/embebed.php?id=" + secCode
					log("Source Link: $srcUrl")

					rtmpUrl = "rtmp://178.33.229.122:1935/liverepeater/_definst_/" + secCode + " pageUrl=http://surk.tv/ playpath=" + secCode 
				}
				
				else if (srcUrl.contains("http://www.007stream.com")){

					log("Source Link: $srcUrl")
					
					def fileMatcher = linkTitle =~ '(?s)file=(.*?)&'
					if (!fileMatcher){
						log("No file playpath in " + srcUrl)
						println "No file playpath in " + srcUrl
						return
					}
					String fileNum = fileMatcher[0][1].trim()

					String linkHtml = new URL(srcUrl).getText()
					def urlMatcher = linkHtml =~ '(?s)iframe.src="(.*?)"'
					String urlCode = urlMatcher[0][1].trim()
					String urlHtml = new URL(urlCode).getText()

					def errorMatch
					errorMatch = urlHtml ==~ '(?s).*?>Referer Blocked By Admin.*?'
					if (errorMatch){
						log ("007STREAM - Referer Blocked By Admin - $videoTitle")
						return null
					}
					errorMatch = urlHtml ==~ '(?s).*?<p.*?>Protect stream.*?'
					if (errorMatch){
						log ("007STREAM - Protected stream - $videoTitle")
						return null
					}

					def codeMatcher = urlHtml =~ /(?s)var.sUrl.=.'(.*?)'.*?var.cod1.=.'(.*?)=.*?var.cod2.=.'(.*?)=/
					if(!codeMatcher){
						log ("007 - No rtmp info - $videoTitle")
						return null
					}
					
					String urlbit  = codeMatcher[0][1].trim()
					String cod1bit = codeMatcher[0][2].trim()
					cod1bit = URLEncoder.encode(cod1bit)
					String cod2bit = codeMatcher[0][3].trim()
					cod2bit = URLEncoder.encode(cod2bit)
					String secUrl = urlbit + "?callback=jQuery17&v_cod1=" + cod1bit + "%3D&v_cod2=" + cod2bit + "%3D&_=10"
					String secHtml = new URL(secUrl).getText()
					def secMatcher = secHtml =~ '(?s)result1":"(.*?)"'
					if(!secMatcher){
						log ("007 - No secCode - $videoTitle")
						return null
					}
					
					secCode  = secMatcher[0][1].trim()
					rtmpUrl = "rtmp://stream.dinozap.tv:1935/vod/_definst_/" + secCode + " swfUrl=http://www.007stream.com/player.swf pageUrl=http://www.007stream.com/channel.php?file=" + fileNum + " playpath=" + secCode
				}

				else if (srcUrl.contains("http://www.ustream.tv")){
					

					log("Source Link: $srcUrl")

					def fileMatcher = linkTitle =~ '(?s)popup/(.*?)"'
					def fileMatch = linkTitle ==~ '(?s).*?.*?popup/.*?"'
					if (!fileMatch){
						log ("USTREAM - no popup - $videoTitle")
						return null
					}
					def fileNum = fileMatcher[0][1].trim()
					def linkUrl = "http://cgw.ustream.tv/Viewer/getStream/1/" +fileNum + ".amf"
					String linkHtml = new URL(linkUrl).getText()
					def errorMatch = linkHtml ==~ '(?s).*?status...online.*?'
					if (!errorMatch){
						log ("USTREAM - stream is offline - $videoTitle")
						return null
					}
					def cdnMatch = linkHtml ==~ '(?s).*?cdnUrl.*?'
					def linkMatcher
					String rtmplink
					if (cdnMatch){
						linkMatcher = linkHtml =~ '(?s)cdnUrl...(.*?)[\\x00-\\x20].*?'
						if(!linkMatcher){
							log ("007 - No cdnUrl - $videoTitle")
							return null
						}
					
						rtmplink = linkMatcher[0][1].trim()
					}
					else {
						linkMatcher = linkHtml =~ '(?s)fmsUrl...(.*?)[\\x00-\\x20].*?'
						if(!linkMatcher){
							log ("007 - No fmsUrl - $videoTitle")
							return null
						}
						rtmplink = linkMatcher[0][1].trim()
						rtmplink = rtmplink.replaceFirst("tv/ustreamV","tv:1935/ustreamV")
						rtmplink = rtmplink + "/"
					}
					def linkMatcher2 = linkHtml =~ '(?s)streamName...(.*?)[\\x00-\\x20].*?'
					if(!linkMatcher2){
						log ("Ustream - No secCode - $videoTitle")
						return null
					}

					secCode = linkMatcher2[0][1].trim()
					rtmpUrl = rtmplink + " swfUrl=http://static-cdn1.ustream.tv/swf/live/viewer.rsl:96.swf pageUrl=http://www.ustream.tv playpath=" + secCode + " swfVfy=1 live=1"
				}

				else if (srcUrl.contains("http://www.castalba.tv")){

					def idMatcher = linkTitle =~ '(?s)id="(.*?)"'
					if(!idMatcher){
						log("No id= in " + srcUrl)
						println "No id= in " + srcUrl
						return
					}

					def id = idMatcher[0][1].trim()
					srcUrl = "http://castalba.tv/embed.php?cid=" + id

					log("Source Link: $srcUrl")

					String linkHtml = new URL(srcUrl).getText()
					
					def errorMatch = linkHtml ==~ '(?s).*?Banned due to Copyright Infringement.*?'
					if (errorMatch){
						log ("CASTALBA - Banned due to Copyright Infringement - $videoTitle")
						return null
					}

					def linkMatcher = linkHtml =~ /(?s)flashplayer':.*?"(.*?)".*?'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'.*?'aboutlink':.*?'(.*?)'.*?/
					if(!linkMatcher){
						log ("Castalba - No rtmp info - $videoTitle")
						return null
					}

					String rtmplink = linkMatcher[0][3].trim()
					String swflink  = linkMatcher[0][1].trim()
					String pagelink = linkMatcher[0][4].trim()
					secCode  = linkMatcher[0][2].trim()

					if (rtmplink.contains("rtmp://live.castalba.tv")) rtmplink = "rtmp://174.36.42.120/live"  

					rtmpUrl = rtmplink + " swfUrl=" + swflink + " pageURL=" + pagelink + " playpath=" + secCode 
				}

				else if (srcUrl.contains("http://liveview365.tv")){

					def idMatcher = linkTitle =~ "(?s)id='(.*?)'"
					if(!idMatcher){
						log("No id= in " + srcUrl)
						println "No id= in " + srcUrl
						return
					}

					secCode = idMatcher[0][1].trim()
					srcUrl = "http://liveview365.tv/embedded?id=" + secCode + "&width=620&height=450&domain=88.80.15.211"

					log("Source Link: $srcUrl")

					String linkHtml = new URL(srcUrl).getText()
					
					def errorMatch = linkHtml ==~ '(?s).*?alt="Content Removed.*?'
					if (errorMatch){
						log ("Liveview 365 - Content Removed - $videoTitle")
						return null
					}

					def linkMatcher = linkHtml =~ /(?s)SWFObject.*?'(.*?)'.*?'file',.*?'(.*?)'.*?'streamer',.*?'(.*?)liveview365'.*?'logo.link',.*?'(.*?)'.*?/
					if(!linkMatcher){
						log ("Liveview 365 - No rtmp info - $videoTitle")
						return null
					}
					String rtmplink = linkMatcher[0][3].trim()
					String swflink  = linkMatcher[0][1].trim()
					String pagelink = linkMatcher[0][4].trim()
					secCode  = linkMatcher[0][2].trim()

					rtmpUrl = rtmplink + "live/_definst_/" + secCode + " swfUrl=" + swflink + " pageURL=" + pagelink + " playpath=" + secCode 
				}
				
				else if (srcUrl.contains("http://www.wii-stream.com")){

					def idMatcher = linkTitle =~ '(?s)fid="(.*?)"'
					if(!idMatcher){
						log("No fid= in " + srcUrl)
						println "No fid= in " + srcUrl
						return
					}

					secCode = idMatcher[0][1].trim()

					srcUrl = "http://wii-stream.com/?p=channeldetails&id=" + secCode

					log("Source Link: $srcUrl")

					rtmpUrl = "rtmp://75.126.69.205/live swfUrl=http://wii-stream.com/player/player.swf pageURL=http://wii-stream.com/?p=channeldetails&id=" + secCode + " playpath=" + secCode 
				}

				else if (srcUrl.contains("http://www.castup.tv")){

					def idMatcher = linkTitle =~ '(?s)fid="(.*?)"'
					if (!idMatcher){
						log("No fid= playpath for " + srcUrl)
						println "No fid= playpath for " + srcUrl
						return
					}
					secCode = idMatcher[0][1].trim()

					srcUrl = "http://castup.tv/embed.php?u=" + secCode

					log("Source Link: $srcUrl")

					rtmpUrl = "rtmp://159.253.145.155:1935/live pageUrl=http://www.castup.tv playpath=" + secCode 
				}

				else if (srcUrl.contains("http://www.castamp.com/")){

					def channelMatcher = linkTitle =~ '(?s)channel="(.*?)"'
					if (!channelMatcher){
						log("No channel= playpath for " + srcUrl)
						println "No channel= playpath for " + srcUrl
						return
					}

					secCode = channelMatcher[0][1].trim()

					srcUrl = "http://castamp.com/embed.php?c=" + secCode
					log("Source Link: $srcUrl")
					
					String linkHtml = new URL(srcUrl).getText()
					
					def errorMatch = linkHtml ==~ '(?s).*?player".*?>Channel Blocked.*?'
					if (errorMatch){
						log ("CASTAMP - Channel Blocked - $videoTitle")
						return null
					}

					def linkMatcher = linkHtml =~ /(?s)flashplayer':.*?"(.*?)".*?'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'.*?'aboutlink':.*?'(.*?)'.*?/
					if (!linkMatcher){
						log("No rtmp data in " + srcUrl)
						println "No rtmp data in " + srcUrl
						return
					}

					String swflink  = linkMatcher[0][1].trim()
					secCode  = linkMatcher[0][2].trim()
					String rtmplink = linkMatcher[0][3].trim()
					String pagelink = linkMatcher[0][4].trim()
					rtmpUrl = rtmplink + "/" + secCode + " swfUrl=" + swflink + " pageUrl=http://www.castamp.com" + " playpath=" + secCode
				}

				else if (srcUrl.contains("http://coolsport.tv/") || srcUrl.contains("http://nutjob.eu")) {	
					
					log("Source Link 1: $srcUrl")
					
					if (srcUrl.contains("http://nutjob.eu")){
						linkTitle = openURL( new URL(srcUrl),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
						def channelMatcher = linkTitle =~ '(?s)<iframe.*?src="(.*?)"'
						if (!channelMatcher){
							log("No src= in " + srcUrl)
							println "No src= in " + srcUrl
							return
						}
						
						srcUrl = channelMatcher[0][1].trim()

						log("Source Link 2: $srcUrl")
					}

					def srcUrl_text = openURL( new URL(srcUrl),
					"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
					
					if (srcUrl_text == "") {
						log (srcUrl + " NOT FOUND")
						return null
					}            
					

					def idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>.*?src=["\']http://www.sawlive.tv/embed/(.*?)["\']' 
					def idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript["\']>.*?src=["\']http://www.sawlive.tv/embed/.*?["\'].*?' 
					if (idMatched){
						String refererUrl = srcUrl
						srcUrl = "http://sawlive.tv/embed/" + idMatcher[0][1] 
						log("Source Link 4: $srcUrl")
						srcUrl_text = openURL( new URL(srcUrl),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
						
						def encodeMatcher = srcUrl_text =~ "(?s)unescape\\('(.*?)'"
						def encodeMatched = srcUrl_text ==~ "(?s).*?unescape\\('.*?'.*?"
						if(!encodeMatched){
							log("No encode in " + srcUrl)
							return
						}
						def decoded = URLDecoder.decode(encodeMatcher[0][1])
						
						def srcMatcher = decoded =~ '(?s)src="(.*?)$'
						def srcMatch = decoded ==~ '(?s).*?src=".*?$'
						if (!srcMatch){
							log("No src= in decoded " + srcUrl)
							return
						}
						
						srcUrl = srcMatcher[0][1].replaceFirst("view","watch")
						if (!refererUrl.contains("http://www")) refererUrl = refererUrl.replaceFirst("http://","http://www\\.")
						
						log("Source Link 5: $srcUrl")

						//srcUrl_text = ""								/##

						srcUrl_text = OpenProtURL(srcUrl,refererUrl)	
							

						def rtmpMatcher = srcUrl_text =~ "(?s)var.so.=.new.SWFObject.*?'(.*?)'.*?'file',.*?'(.*?)'.*?'streamer',.*?'(.*?)'.*?'aboutlink',.*?'(.*?)'.*?"
							
						def uri = rtmpMatcher[0][3]
						def swf = rtmpMatcher[0][1]
						def page = rtmpMatcher[0][4]
						def path = rtmpMatcher[0][2]
							
						rtmpUrl = uri + " playpath=" + path + " swfurl=" + swf + " pageurl=" + page + " live=1"
					}

					else{
						idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>\\s?id=["\'](.*?)["\'].*?src=["\'](.*?)["\']' 
						idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript["\']>\\s?id=["\'].*?["\'].*?src=["\'].*?["\'].*?'
						if (!idMatched){
							idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>\\s?fid=["\'](.*?)["\'].*?src=["\'](.*?)["\']'
							idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript["\']>\\s?fid=["\'].*?["\'].*?src=["\'].*?["\'].*?'
							if (!idMatched){
								idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>\\s?channel=["\'](.*?)["\'].*?src=["\'](.*?)["\']'
								idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript\\s?channel=["\'].*?["\'].*?src=["\'].*?["\'].*?'
								if (!idMatched){
									log("No playpath or src= in " + srcUrl)
									return
								}
							}
						}

						secCode = idMatcher[0][1]
					
						if (idMatcher[0][1] =="test") return
						
						if(idMatcher[0][2].contains("www.yycast.com")) {
							rtmpUrl = "rtmp://212.7.212.37:1935/live" + " playpath=" + secCode + " pageUrl=http://www.yycast.com/embed.php?fileid=" + idMatcher[0][1] + " swfUrl=http://cdn.yycast.com/player/player.swf live=1" 
						}
						else if(idMatcher[0][2].contains("yukons.net")) {
							rtmpUrl = "rtmp://198.144.153.139:1935/kuyo playpath=" + secCode + " pageUrl=http://www.yukons.net swfurl=http://yukons.net/yukplay.swf live=1"
						}
						else if(idMatcher[0][2].contains("reyhq.com")) {
							rtmpUrl = "rtmp://89.248.174.117/live playpath=" + secCode + " swfUrl=http://www.reyhq.com/player/player-licensed.swf pageurl=http://www.reyhq.com live=1"
						}
						else if(idMatcher[0][2].contains("coolsport.tv/livegame.js")) {
							srcUrl = "http://embeds.coolsport.tv/livegame.php?id=" + idMatcher[0][1] + "&width=640&height=460"
							log("Source Link 5: $srcUrl")

							if (URLExists(srcUrl)) srcUrl_text = openURL( new URL(srcUrl),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							else {
								log("Unable to access " + srcUrl)
								return
							}

							idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>id=["\'](.*?)["\'];.*?src=["\'](.*?)["\']'
							idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript["\']>id=["\'].*?["\'];.*?src=["\'].*?["\'].*?'
							if (!idMatched){
								log("No playpath or src= in " + srcUrl)
								return
							}


							secCode = idMatcher[0][1]

							//build rtmp link for default src="http://embeds.coolsport.tv/livegame.js"
							rtmpUrl = "rtmp://37.220.34.59:1935/liverepeater/ playpath=" + secCode + " pageUrl=http://stream4.tv/player.php swfurl=http://cdn.stream4.tv/player.swf live=1"
						}
						else if(idMatcher[0][2].contains("coolsport.tv/livegame")) {
							def refererUrl = srcUrl
							srcUrl = "http://embeds.coolsport.tv/livegame2.php?id=" + idMatcher[0][1] + "&width=640&height=460"
							log("Source Link 6: $srcUrl")

							if (URLExists(srcUrl)) srcUrl_text = OpenProtURL(srcUrl,refererUrl)
							else {
								log("Unable to access " + srcUrl)
								return
							}

							idMatcher = srcUrl_text =~ '(?s)<script type=["\']text/javascript["\']>id=["\'](.*?)["\'];.*?src=["\'](.*?)["\']'
							idMatched = srcUrl_text ==~ '(?s).*?<script type=["\']text/javascript["\']>id=["\'].*?["\'];.*?src=["\'].*?["\'].*?'
							if (!idMatched){
								log("No playpath or src= in " + srcUrl)
								return
							}

							secCode = idMatcher[0][1]
							
							if (idMatcher[0][2].contains("featve.com")){
							
								refererUrl = srcUrl
								def pageUrl = idMatcher[0][2].replaceFirst("js","php")
								srcUrl = pageUrl + "?id=" + idMatcher[0][1] + "&width=640&height=460"

								log("Source Link 7: $srcUrl $refererUrl")
								
								//srcUrl_text = OpenProtURL(srcUrl,refererUrl)
								def ua="Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)"
								srcUrl_text = new GZIPInputStream (new URL(srcUrl).newInputStream(requestProperties:['Accept-Encoding': 'gzip,deflate', 'Referer': refererUrl, 'User-Agent': ua])).text			
								
								idMatcher = srcUrl_text =~ "(?s)flashvars.*?'file':.*?'(.*?)'.*?'streamer':.*?'(.*?)'.*?embedSWF.'(.*?)'"
								idMatched = srcUrl_text ==~ "(?s).*?flashvars.*?'file':.*?'.*?'.*?'streamer':.*?'.*?'.*?embedSWF.'.*?'.*?"
								if (!idMatched){
									log("No playpath or src= in " + srcUrl)
									return
								}
							
								def uri = idMatcher[0][2]
								def swf = idMatcher[0][3]
								secCode = idMatcher[0][1]


								rtmpUrl = uri + " playpath=" + secCode + " pageUrl=" + pageUrl + " swfurl=" + swf + " token=" + Token + " live=1"
							}

							if (idMatcher[0][2].contains("stream4.tv")){
								//build rtmp link for default src="http://stream4.tv/player2.js"
								rtmpUrl = "rtmp://rtmp.stream4.tv:1935/liverepeater/ playpath=" + secCode + " pageUrl=http://stream4.tv/player2.php swfurl=http://cdn.stream4.tv/player2.swf live=1"
							}
						}

						else if (idMatcher[0][2].contains("aka.castvideo.info/player.js") || idMatcher[0][2].contains("sportodin.com/player.js")) {
							//build rtmp link for src="http://aka.castvideo.info/player.js" or src='http://sportodin.com/player.js'></script>
							rtmpUrl = "rtmp://37.220.34.59:1935/liverepeater/_definst_/" + idMatcher[0][1] + " live=1"
						}
						else{	
							log("No playpath or src= found in " + srcUrl)
							return
						}				
					}
				}
				
				else if (srcUrl.contains("http://hqfooty.tv/") || srcUrl.contains("http://frametv2.blogspot.co.uk") || srcUrl.contains("http://frametv3.blogspot.co.uk")){

					
					log("Source Link 1: $srcUrl")
					
					if (srcUrl.contains("http://frametv") || srcUrl.contains("http://hqfooty.tv/s/")){
						
						linkTitle = openURL( new URL(srcUrl),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
						def srcMatcher = linkTitle =~ '(?s)<iframe.*?src="(.*?)"'
						if (!srcMatcher){
							log("No src= in " + srcUrl)
							println "No src= in " + srcUrl
							return
						}
						srcUrl = srcMatcher[0][1].trim()
						
						log("Source Link 2: $srcUrl")
					}

					String srcUrl_text = openURL( new URL(srcUrl),
					"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
					
					if (srcUrl_text == "") {
						log (srcUrl + " NOT FOUND")
						return null
					}            
					

					def idMatcher
					def idMatch = srcUrl_text ==~ '(?s).*?fid=".*?'
					if (idMatch) idMatcher = srcUrl_text =~ '(?s)fid="(.*?)".*?src="(.*?)".*?'
					else idMatcher = srcUrl_text =~ /(?s)fid=(.*?)".*?src='(.*?).script.*?/
					
					if(!idMatcher){
						log("No fid= in " + srcUrl)
						println "No fid= in " + srcUrl
						return
					}
					
					srcUrl =idMatcher[0][2].trim()
					secCode =idMatcher[0][1].trim()
	
					log("Source Link 3: $srcUrl")
					
					
					if(srcUrl.contains("www.hdcast.tv")){ 
						rtmpUrl = "rtmp://46.246.29.154:1935/live playpath=" + secCode + " pageUrl=http://www.hdcast.tv swfUrl=http://www.hdcast.com/player/player.swf live=1" 
					}
					else  // for www.ukcast.tv
						rtmpUrl = "rtmp://live.ukcast.tv/broadcast playpath=" + secCode + " pageUrl=http://www.ukcast.tv swfUrl=http://www.ukcast.tv/player/player.swf live=1" 
				}

				else if (srcUrl.contains("http://liveall.tv/")){
					
					log("Source Link: $srcUrl")

					String linkHtml = new URL(srcUrl).getText()

					def linkMatcher = linkHtml =~ /(?s)SWFObject.*?"(.*?)".*?'streamer'.*?testkey=(.*?)'.*?file','(.*?)'*?'/
					if (!linkMatcher){
						log("No rtmp data in " + srcUrl)
						println "No rtmp data in " + srcUrl
						return
					}

					rtmpUrl = "rtmp://109.163.236.74:80/liveall?testkey=" + linkMatcher[0][2] + " playpath=" + linkMatcher[0][3] + " pageUrl=http://wds.liveall.tv/ swfurl=" + linkMatcher[0][1] + " live=1" 
				}

				else if (srcUrl.contains("http://castasap.com")){
					

					def secMatcher = linkTitle =~ '(?s)javascript">.*?chname="(.*?)"'
					def secMatch = linkTitle =~ '(?s).*?javascript">.*?chname=".*?".*?'
					if(!secMatch) secMatcher = linkTitle =~ '(?s)chname=(.*?)[&"]'
					if (!secMatcher){
						log("No chname= playpath in " + srcUrl)
						println "No chname= playpath in " + srcUrl
						return
					}

					secCode = secMatcher[0][1].trim()

					srcUrl = "http://castasap.com/embedhd.php?chname=" + secCode

					log("Source Link: $srcUrl")

					String linkHtml = new URL(srcUrl).getText()
					
					
					def linkMatcher = linkHtml =~ /(?s)flashvars.*?file:.*?'(.*?)'.*?streamer:.*?'(.*?)'.*?/
					if (!linkMatcher){
						log("No rtmp data in " + srcUrl)
						println "No rtmp data in " + srcUrl
						return
					}


					rtmpUrl = "rtmp://" + linkMatcher[0][2] + " playpath=" + linkMatcher[0][1] + " pageurl=http://castasap.com swfVfy=0 live=1"
				}

				else if (srcUrl.contains("http://www.hdcast.tv")) {
				

					
					log("Source Link: $srcUrl")

					def secMatcher = linkTitle =~ '(?s)<script>.*?fid=(.*?)"'
					if (secMatcher) secCode = secMatcher[0][1].trim()
					
					else {
						secMatcher = linkTitle =~ '(?s)iframe.*?http://www.hdcast.tv/embed.php(.*?)\\&.*?'
						if (!secMatcher){ 
							log("No link in " + srcUrl)
							println "No link in " + srcUrl
							return
						}
						
						secCode = secMatcher[0][1].trim()
						
						srcUrl= "http://www.hdcast.tv/embed.php" + secMatcher[0][1]
						
						linkTitle = openURL( new URL(srcUrl),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
						

						secMatcher = linkTitle =~ /(?s)'file','(.*?)'/

						if (!secMatcher) {
							log("No file playpath in " + srcUrl)
							println "No file playpath in " + srcUrl
							return
						}
						
						secCode = secMatcher[0][1]
					}	

					srcUrl = "http://www.hdcast.tv/script.php?fid=" + secCode

					log("Source Link: $srcUrl")

					rtmpUrl = "rtmp://46.246.29.154:1935/live playpath=" + secCode + " pageUrl=http://www.hdcast.tv swfUrl=http://www.hdcast.com/player/player.swf live=1" 
				}

				else if (srcUrl.contains("http://cricfree.tv") 
						|| srcUrl.contains("http://www.yycast.com")
						|| srcUrl.contains("http://mypremium.tv")
						|| srcUrl.contains("http://www.mips.tv")){


					log("Source Link 1: $srcUrl")

					if (srcUrl.contains("http://cricfree.tv")){

					}
					
					else
					if (srcUrl.contains("http://www.yycast.com/embed")){
					}
					
					else
					if (srcUrl.contains("http://mypremium.tv")){

		 
						linkTitle = openURL( new URL(srcUrl),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
						
						def srcMatcher = linkTitle =~ '(?s)lacehold.location.replace\\("(.*?)"'
						if (!srcMatcher){
							log("No em link in " + srcUrl)
							println "No em link in " + srcUrl
							return
						}
						srcUrl = srcMatcher[0][1].trim() + "1.shtml"
						
						log("Source Link 2: $srcUrl")
						
					}
					
					if (srcUrl.contains("http://cricfree.tv") || srcUrl.contains("http://www.yycast.com/embed") || srcUrl.contains("http://mypremium.tv")){
						linkTitle = openURL( new URL(srcUrl),
								"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							
						def srcMatcher = linkTitle =~ /(?s)javascript['"].*?src=['"](.*?)['"]/
						if (!srcMatcher){
							log("No src link in " + srcUrl)
							println "No src link in " + srcUrl
							return
						}
						srcUrl = srcMatcher[0][1]
						
						log("Source Link 3: $srcUrl")
					}

					if(srcUrl.contains("http://www.mips.tv")){
						
						def idMatcher = linkTitle =~ /(?s)javascript["']>.*?channel=["'](.*?)["']/
						def idMatch = linkTitle ==~ /(?s).*?javascript["']>.*?channel=["'].*?["'].*?/
						if (!idMatch){
							log("No channel= in " + srcUrl)
							println "No channel= playpath in " + srcUrl
							return
						}
						
						secCode = idMatcher[0][1]
						
						//* now get uri if required (loadbalancer only works once)
						if(!mipsUri){
							def linkUri = openURL( new URL("http://www.mips.tv:1935/loadbalancer"),
							"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
							println linkUri
							def UriMatcher = linkUri =~ 'redirect=(.*?)$'
							if(!UriMatcher) mipsUri = "50.23.113.212"
							else mipsUri = UriMatcher[0][1]
						}


						rtmpUrl = "rtmp://" + mipsUri + ":1935/live playpath=" + secCode + " swfurl=http://mips.tv/content/scripts/eplayer.swf pageurl=http://www.mips.tv live=1"
					}	
					
					else if(srcUrl.contains("reyhq.com")) {
					

						def idMatcher = linkTitle =~ /(?s)javascript'>.*?fid='(.*?)'/
						def idMatch = linkTitle  ==~ /(?s).*?javascript'>.*?fid='.*?/
						if (!idMatch){
							log("No id= playpath in " + srcUrl)
							println "No id= playpath in " + srcUrl
							return
						}

						secCode = idMatcher[0][1]

						rtmpUrl = "rtmp://89.248.174.117/live playpath=" + secCode + " swfUrl=http://www.reyhq.com/player/player-licensed.swf pageurl=http://www.reyhq.com live=1"
					}

					else if(srcUrl.contains("ezcast.tv")) {

						def idMatcher = linkTitle =~ /(?s)javascript'>.*?channel='(.*?)'/
						def idMatch = linkTitle  ==~ /(?s).*?javascript'>.*?channel='.*?/
						if (!idMatch){
							log("No id= playpath in " + srcUrl)
							println "No id= playpath in " + srcUrl
							return
						}

						secCode = idMatcher[0][1]

						rtmpUrl = "rtmp://212.7.206.54/live playpath=" + secCode + " swfUrl=http://www.ezcast.tv/static/scripts/eplayer.swf conn=S:OK pageurl=http://www.ezcast.tv/embedded/ live=1"
					}

					else
					if(srcUrl.contains("http://www.webcaston.com")){
						
						def idMatcher = linkTitle =~ /(?s)javascript">.*?fid=".*?fid="(.*?)"/
						def idMatch = linkTitle  ==~ /(?s).*?javascript">.*?fid=".*?fid=".*?/
						if (!idMatch){
							log("No id= playpath in " + srcUrl)
							println "No id= playpath in " + srcUrl
							return
						}

						secCode = idMatcher[0][1]
						rtmpUrl = "rtmp://85.12.5.3/wl/channel playpath=" + secCode + " app=wl/channel swfurl=http://www.webcaston.com/player/player.swf pageurl=http://www.webcaston.com/embed.php live=1"
					}

					else
					if(srcUrl.contains("http://partner.googleadservices")){
					
						def idMatcher = linkTitle =~ /(?s)javascript">.*?'file':.*?'(.*?)'/
						def idMatch = linkTitle  ==~ /(?s).*?javascript">.*?'file':.*?'.*?'.*?/
						if (!idMatch){
							log("No id= playpath in " + srcUrl)
							println "No id= playpath in " + srcUrl
							return
						}

						secCode = idMatcher[0][1]

						rtmpUrl = "rtmp://212.7.206.66:1935/live playpath=" + secCode + " swfurl=http://cdn.yycast.com/player/player.swf pageurl=http://www.yycast.com live=1"
					}

					else
					if(srcUrl.contains("http://www.ucaster.eu")){
						def liveMatcher = linkTitle =~ "(?s)<script.*?channel='(.*?)'.*?g='(.*?)'.*?src='.*?ucaster\\.eu.*?'></script>.*?"
						if (liveMatcher.count > 0) {
							srcUrl = "http://www.ucaster.eu/embedded/" + liveMatcher [0][1] + "/" + liveMatcher [0][2] + "/620/490"
							
							log("Source Link 4: $srcUrl")

							if (!URLExists(srcUrl)) {
								log (srcUrl + " is DEADLINK")
								println srcUrl + " is DEADLINK"
								return null
							}
							
							println "open link " + srcUrl
							
							def srcUrl_text = OpenProtURL(srcUrl,"http://www.cricfree.tv")
							
							liveMatcher = srcUrl_text =~ "FlashVars.*?id=(.*?)&s=(.*?)&.*?"
							
							if(!liveMatcher){
								println "No Playpath in " + srcUrl
								log("No Playpath in " + srcUrl)
								return
							}

							secCode = liveMatcher [0][2] + "?id=" + liveMatcher [0][1]
							
							//* now get uri if required (loadbalancer only works once)
							if(!ucasterUri){
								def linkUri = openURL( new URL("http://www.ucaster.eu:1935/loadbalancer"),
									"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1") 
								println linkUri
								def UriMatcher = linkUri =~ 'redirect=(.*?)$'
								if(!UriMatcher) ucasterUri = "174.36.251.140"
								else ucasterUri = UriMatcher[0][1]
							}
							
							rtmpUrl = "rtmp://" + ucasterUri + "/live playpath=" + secCode + " pageUrl=http://www.ucaster.eu swfurl=http://www.ucaster.eu/static/scripts/eplayer.swf live=1"
						} 
					}
					else
					if(srcUrl.contains("http://jimey.tv")){
						def liveMatcher = linkTitle  =~ "<script.*?channel='(.*?)'.*?user='(.*?)'.*?src='.*?jimey\\.tv.*?'></script>"
						def return_val = '-NOTFOUND-'        
						if (liveMatcher.count > 0) {
						

							def referrer = srcUrl
							srcUrl= "http://jimey.tv/player/embedplayer.php?channel=" + liveMatcher [0][1] + "&user=" + liveMatcher[0][2] +"&width=620&height=490"
							log("Source Link 3: $srcUrl")

							if (!URLExists(srcUrl)) {
								log (srcUrl + " is DEADLINK")
								println srcUrl + " is DEADLINK"
								return null
							}
							
							println "open link " + srcUrl
							

							def srcUrl_text = OpenProtURL(srcUrl,referrer)
					
							
							def errorMatch = srcUrl_text ==~ '(?s).*?channel has been deleted.*?'
							if (errorMatch){
								log ("jimey - Channel Deleted - $secUrl")	
								return null
							}
							
							
							liveMatcher = srcUrl_text =~ "value='file=(.*?)&.*?"
							
							if(!liveMatcher){
								println "No Playpath in " + srcUrl
								log("No Playpath in " + srcUrl)
								return
							}
							
							secCode = liveMatcher [0][1]
							
							rtmpUrl = "rtmpe://64.191.80.10/edge playpath=" + secCode + " swfurl=http://jimey.tv/player/fresh.swf pageUrl=http://www.jimey.tv live=1"
						} 
					}
						
					else {
						
						def idMatcher = linkTitle =~ '(?s)YYCAST_EMBED_ID -->.*?-->.*?javascript">.*?fid="(.*?)"'
						def idMatch = linkTitle  ==~ '(?s).*?YYCAST_EMBED_ID -->.*?-->.*?javascript">.*?fid=".*?".*?'
						if (!idMatch){
							idMatcher = linkTitle =~ '(?s)javascript["\']>\\s?fid=["\'](.*?)["\']'
							idMatch = linkTitle  ==~ '(?s).*?javascript["\']>\\s?fid=["\'].*?["\'].*?'
							if (!idMatch){
								idMatcher = linkTitle =~ '(?s)<script> fid=(.*?)[&;]'
								idMatch = linkTitle ==~ '(?s).*?<script> fid=.*?'
								if (!idMatch){
									idMatcher = linkTitle =~ '(?s)src=.*?fileid=(.*?)[&;]'
									idMatch = linkTitle ==~ '(?s).*?src=.*?fileid=.*?[&;].*?'
									if (!idMatch){
										idMatcher = linkTitle =~ /(?s)javascript["']>.*?channel=["'](.*?)["']/
										idMatch = linkTitle ==~ /(?s).*?javascript["']>.*?channel=["'].*?["'].*?/
										if (!idMatch){
											log("No id= playpath in " + srcUrl)
											println "No id= playpath in " + srcUrl
											return
										}
									}
								}
							}
						}

						secCode = idMatcher[0][1].trim()
					
						if(srcUrl.contains("www.liveflash.tv")){
							//* now get uri if required (loadbalancer only works once)
							if(!liveflashUri){
								def linkUri = openURL( new URL("http://www.liveflash.tv:1935/loadbalancer"), 
									"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.83 Safari/537.1")
								println linkUri
								def uriMatcher = linkUri =~ 'redirect=(.*?)$'
								if (!uriMatcher) liveflashUri = "75.126.107.118"
								else liveflashUri = uriMatcher[0][1]
							}

							srcUrl = "http://www.liveflash.tv.com/embedplayer/" + secCode + "/1/620/490"

							log("Source Link 4: $srcUrl")
								

							rtmpUrl = "rtmp://" + liveflashUri + ":1935/stream playpath=" + secCode + " swfurl=http://www.liveflash.tv/resources/scripts/eplayer.swf pageurl=http://www.liveflash.tv live=1"
						}
						
						else if(srcUrl.contains("www.livego.tv")){
							srcUrl = "http://livego.tv/embed.php?live=" + secCode + "&vw=620&vh=490"

							log("Source Link 4: $srcUrl")

							rtmpUrl = "rtmp://178.32.49.53:1930/liveorigin playpath=" + secCode + " swfUrl=http://livego.tv/player/player-licensed.swf pageUrl=http://www.livego.tv live=1"
						}
						
						else{
							srcUrl = "http://www.yycast.com/embed.php?fileid=" + secCode + "/1/620/490"

							log("Source Link 4: $srcUrl")


							rtmpUrl = "rtmp://46.19.140.58:1935/live playpath=" + secCode + " swfurl=http://cdn.yycast.com/player/player.swf pageurl=http://www.yycast.com live=1"
						}
					}
				}


				log("Extracted url for $videoTitle")
				
				cacheKey = "hahasport_" +  videoUrl 
				
				expiresImmediately = true
				
				expiryDate = new Date(itemRefresha * 60000)

				item.additionalInfo.put('XcontentUrl',rtmpUrl)
				item.additionalInfo.put('XthumbnailUrl',thumbnailUrl)
				item.additionalInfo.put('XexpiresOn',expiryDate)
				item.additionalInfo.put('XexpiresImmediately',expiresImmediately)
				item.additionalInfo.put('XcacheKey',cacheKey)
				def oindx = item.getAdditionalInfo()['oindx']
				if(oindx){
					newitems[oindx] = item
				}
				else {
					oindx = newitems.size()
					item.additionalInfo.put('oindx',oindx)
					newitems << item
				}
			} //End of not Refresh Item or No More Items
		} //END of non gen EXTRACT
		
		else{   //START OF gen GENERATE
			println "\r\nGenerating Url for $videoTitle"
			log ("Generated url for $videoTitle")
			item.additionalInfo.put('gen',"false")
			def oindx = item.getAdditionalInfo()['oindx']
			rtmpUrl = olditems.getAt(oindx).getAdditionalInfo()['XcontentUrl']
			thumbnailUrl = olditems.getAt(oindx).getAdditionalInfo()['XthumbnailUrl']
			expiryDate = olditems.getAt(oindx).getAdditionalInfo()['XexpiresOn']
			expiresImmediately = olditems.getAt(oindx).getAdditionalInfo()['XexpiresImmediately']
			cacheKey = olditems.getAt(oindx).getAdditionalInfo()['XcacheKey']
		}

		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: rtmpUrl, thumbnailUrl: thumbnailUrl,
			cacheKey: cacheKey, expiresOn: expiryDate, expiresImmediately: expiresImmediately, live: true)
	}
	
	static void main(args) {
		HaHaSport extractor = new HaHaSport()
				
		assert extractor.extractorMatches( new URL("http://www.hahasport.com/c-4.html") )
		assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") )
		WebResourceContainer container  = extractor.extractItems( new URL("http://www.hahasport.com/?refresh=120&estreams=9"), -1)    
		println "\r\n" + container

		container.getItems().each {																					 
		ContentURLContainer result = extractor.extractUrl(it, PreferredQuality.MEDIUM)							 
		println result 														
		}


	}
}
